﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Sales.Quotations
{
    public partial class QuotationDetails : System.Web.UI.Page
    {
        private Entities.Quotations currentQuotation;
        private Entities.QuotationsDetails currentQuotationsDetails;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdOrdersID.Value = Request.QueryString["UniqueID"].ToString();
                    BindQuotationsDetails();
                }
                else
                {
                    Response.Redirect("~/Admin/Sales/Sales.aspx", false);
                }
            }
        }

        private void BindQuotationsDetails()
        {
            currentQuotation = QuotationsBL.GetItem(Guid.Parse(hdOrdersID.Value.Trim()), string.Empty, DateTime.MinValue, DateTime.MinValue);

            if (currentQuotation != null)
            {
                grdOrderDetails.DataSource = currentQuotation.QuotationsDetailsList;
                grdOrderDetails.DataBind();

                btnDownLoadQuotation.Visible = lnkViewQuotation.Visible = !string.IsNullOrEmpty(currentQuotation.QuotationsNumber);
                lnkViewQuotation.NavigateUrl = "~/Admin/Sales/Quotations/ViewPDFQuotation.aspx?UniqueID=" + currentQuotation.UniqueID.ToString();

                int modifiedItems = (from qd in currentQuotation.QuotationsDetailsList
                                     where qd.UnitPrice != qd.OrderPrice
                                     select qd).Count();

                lnkViewQuotation.Visible = (modifiedItems > 0);
            }
        }

        protected void btnDownLoadQuotation_Click(object sender, EventArgs e)
        {
            Guid ordersID = new Guid(hdOrdersID.Value);
            currentQuotation = QuotationsBL.GetItem(ordersID, string.Empty, DateTime.MinValue, DateTime.MinValue);

            if (currentQuotation != null)
            {
                int modifiedItems = (from qd in currentQuotation.QuotationsDetailsList
                                     where qd.UnitPrice > qd.OrderPrice
                                     select qd).Count();

                if (modifiedItems > 0)
                {
                    GeneratePDF.GenerateQuotationsPDF(Guid.Parse(hdOrdersID.Value.Trim()), true, Response);
                }
                else
                {
                    WebUtilities.ShowMessage(this, "Item price has not been revised. Please make changes in item price and try again.");
                }
            }
        }

        protected void lnkEditOrder_Click(object sender, EventArgs e)
        {
            hdQuotationDetailsID.Value = string.Empty;
            LinkButton lnkEditOrder = (LinkButton)sender;
            if (lnkEditOrder != null)
            {
                hdQuotationDetailsID.Value = lnkEditOrder.CommandArgument.ToString();
                Guid quotationsDetailsID = new Guid(hdQuotationDetailsID.Value);
                currentQuotationsDetails = QuotationsDetailsBL.GetItem(quotationsDetailsID, Guid.Empty, string.Empty);

                currentQuotation = QuotationsBL.GetItem(currentQuotationsDetails.QuotationsID, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentQuotationsDetails != null)
                {
                    lblProductUnitPrice.Text = currentQuotationsDetails.OrderPrice.ToString("SGD 0.00");
                    txtRemarks.Text = currentQuotationsDetails.Remarks.Trim();
                    if (currentQuotation.QuotationsStatus.Trim().ToLower().Equals("processed"))
                        txtQuotationPrice.Enabled = false;
                    ScriptManager.RegisterStartupScript(this, GetType(), "testscript", "$('#divPaymentStatus').modal();", true);
                }
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (hdQuotationDetailsID.Value.Trim().Length != 0)
            {
                if (ValidationUtility.ValidateDecimal(txtQuotationPrice.Text.Trim()))
                {
                    Guid quotationsDetailsID = new Guid(hdQuotationDetailsID.Value);
                    currentQuotationsDetails = QuotationsDetailsBL.GetItem(quotationsDetailsID, Guid.Empty, string.Empty);

                    if (currentQuotationsDetails != null)
                    {
                        string remarks = string.Empty;

                        if (currentQuotationsDetails.OrderPrice != decimal.Parse(txtQuotationPrice.Text.Trim()))
                        {
                            remarks += string.Format("{0} price changed from {1} to {2}.", currentQuotationsDetails.ProductName, currentQuotationsDetails.OrderPrice.ToString("0.00"), decimal.Parse(txtQuotationPrice.Text.Trim()).ToString("0.00"));
                        }

                        currentQuotationsDetails.Mode = GlobalConfigurations.Mode.Update;
                        currentQuotationsDetails.OrderPrice = decimal.Parse(txtQuotationPrice.Text.Trim());
                        currentQuotationsDetails.Amount = currentQuotationsDetails.Quantity * currentQuotationsDetails.OrderPrice;
                        currentQuotationsDetails.Remarks = txtRemarks.Text.Trim();

                        if (QuotationsDetailsBL.Save(currentQuotationsDetails))
                        {
                            currentQuotation = QuotationsBL.GetItem(currentQuotationsDetails.QuotationsID, string.Empty, DateTime.MinValue, DateTime.MinValue);

                            currentQuotation.SubTotal = (from qd in currentQuotation.QuotationsDetailsList
                                                         select qd).Sum(r => r.Amount);

                            currentQuotation.TotalBeforeGST = (currentQuotation.SubTotal - currentQuotation.Discount);
                            currentQuotation.GST = (currentQuotation.TotalBeforeGST * 7 / 100);
                            currentQuotation.Total = (currentQuotation.TotalBeforeGST + currentQuotation.GST + currentQuotation.Shipping);
                            currentQuotation.Mode = GlobalConfigurations.Mode.Update;
                            currentQuotation.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);
                            QuotationsBL.Save(currentQuotation);

                            if (remarks.Trim().Length != 0)
                                AuditTrailBL.Save(currentQuotation.UniqueID, WebSession.GetUserIP(), remarks, Guid.Empty, currentQuotation.AdminUserAccountID);

                            WebUtilities.ShowMessage(this, "Quotations details has been modified successfully");
                            BindQuotationsDetails();
                        }
                    }
                }
                else
                {
                    lblEditError.Text = "Please enter valid Product Price";
                    ScriptManager.RegisterStartupScript(this, GetType(), "testscript", "$('#divPaymentStatus').modal();", true);
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            hdQuotationDetailsID.Value = string.Empty;
        }
    }
}